<div class="form-group" id="add-acudiente">

<?php
use kartik\grid\GridView;
use kartik\builder\TabularForm;
use yii\data\ArrayDataProvider;
use yii\helpers\Html;
use yii\widgets\Pjax;

$dataProvider = new ArrayDataProvider([
    'allModels' => $row,
    'pagination' => [
        'pageSize' => -1
    ]
]);
echo TabularForm::widget([
    'dataProvider' => $dataProvider,
    'formName' => 'Acudiente',
    'checkboxColumn' => false,
    'actionColumn' => false,
    'attributeDefaults' => [
        //'type' => TabularForm::INPUT_TEXT,
    ],
    'attributes' => [
        "id" => ['type' => TabularForm::INPUT_HIDDEN, 'columnOptions' => ['hidden'=>true]],
        'identificacion' => ['type' => TabularForm::INPUT_TEXT],
        'tipo' => [
            'label' => 'Tipo documento',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Tipodocumento::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                'options' => ['placeholder' => 'Choose Tipo documento'],
            ],
            'columnOptions' => ['width' => '200px','hidden'=>false]
        ],
        'primer_nombre' => ['type' => TabularForm::INPUT_TEXT,'columnOptions' => ['width' => '400px']],
        'segundo_nombre' => ['type' => TabularForm::INPUT_TEXT,'columnOptions' => ['width' => '200px']],
        'primer_apellido' => ['type' => TabularForm::INPUT_TEXT,'columnOptions' => ['width' => '400px']],
        'segundo_apellido' => ['type' => TabularForm::INPUT_TEXT,'columnOptions' => ['width' => '200px']],
        'genero' => [
            'label' => 'Género',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Genero::find()->orderBy('genero')->asArray()->all(), 'id', 'genero'),
                'options' => ['placeholder' => 'Género', ],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'parentesco' => [
            'label' => 'Parentesco',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Parentesco::find()->orderBy('parentesco')->asArray()->all(), 'id', 'parentesco'),
                'options' => ['placeholder' => 'Parentesco'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'rh' => [
            'label' => 'Rh',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Rh::find()->orderBy('rh')->asArray()->all(), 'id', 'rh'),
                'options' => ['placeholder' => 'Rh'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'direccion' => ['type' => TabularForm::INPUT_TEXT,'columnOptions' => ['width' => '200px','hidden'=>false]],
        'fijo' => ['type' => TabularForm::INPUT_TEXT,'columnOptions' => ['width' => '200px','hidden'=>true]],
        'movil' => ['type' => TabularForm::INPUT_TEXT,'columnOptions' => ['width' => '200px']],
        'email' => ['type' => TabularForm::INPUT_TEXT,'columnOptions' => ['width' => '200px']],
        
        'del' => [
            'type' => 'raw',
            'label' => '',
            'value' => function($model, $key) {
                return
                    Html::hiddenInput('Children[' . $key . '][id]', (!empty($model['id'])) ? $model['id'] : "") .
                    Html::a('<i class="glyphicon glyphicon-trash"></i>', '#', ['title' =>  'Delete', 'onClick' => 'delRowAcudiente(' . $key . '); return false;', 'id' => 'acudiente-del-btn']);
            },
        ],
    ],
    'gridSettings' => [
        'panel' => [
            'heading' => false,
            'type' => GridView::TYPE_DEFAULT,
            'before' => false,
            'footer' => false,
            'after' => Html::button('<i class="glyphicon glyphicon-plus"></i>' . 'Agregar', ['type' => 'button', 'class' => 'btn btn-success kv-batch-create', 'onClick' => 'addRowAcudiente()']),
        ]
    ]
]);
echo  "    </div>\n\n";
?>